package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.SeccionJ73Dao;
import com.ejie.ab04b.model.SeccionJ73;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * SeccionesServiceImpl generated by UDA, 27-jul-2016 11:29:27.
 * 
 * @author UDA
 */

@Service(value = "seccionJ73Service")
public class SeccionJ73ServiceImpl implements SeccionJ73Service {

	@Autowired()
	private SeccionJ73Dao seccionesDao;

	/**
	 * Inserts a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the seccion J 73
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SeccionJ73 add(SeccionJ73 secciones) {
		return this.seccionesDao.add(secciones);
	}

	/**
	 * Updates a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the seccion J 73
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SeccionJ73 update(SeccionJ73 secciones) {
		return this.seccionesDao.update(secciones);
	}

	/**
	 * Finds a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the seccion J 73
	 */
	public SeccionJ73 find(SeccionJ73 secciones) {
		return (SeccionJ73) this.seccionesDao.find(secciones);
	}

	/**
	 * Deletes a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *
	 * @param secciones the secciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(SeccionJ73 secciones) {
		this.seccionesDao.remove(secciones);
	}

	/**
	 * Finds a list of rows in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Secciones>
	 *
	 * @param secciones the secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<SeccionJ73> findAll(SeccionJ73 secciones,
			JQGridRequestDto jqGridRequestDto) {
		return (List<SeccionJ73>) this.seccionesDao.findAll(secciones,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Secciones table using like.
	 * 
	 *  secciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Secciones>
	 *
	 * @param secciones the secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<SeccionJ73> findAllLike(SeccionJ73 secciones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<SeccionJ73>) this.seccionesDao.findAllLike(secciones,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Secciones table.
	 * 
	 *  filterSecciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Secciones>
	 *
	 * @param filterSecciones the filter secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<SeccionJ73> filter(SeccionJ73 filterSecciones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<SeccionJ73> listaSecciones = this.seccionesDao
				.findAllLike(filterSecciones, jqGridRequestDto, false);
		Long recordNum = this.seccionesDao.findAllLikeCount(
				filterSecciones != null ? filterSecciones : new SeccionJ73(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<SeccionJ73>> reorderSelection = this.seccionesDao
					.reorderSelection(filterSecciones, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<SeccionJ73>(jqGridRequestDto,
					recordNum, listaSecciones, reorderSelection);
		}
		return new JQGridResponseDto<SeccionJ73>(jqGridRequestDto, recordNum,
				listaSecciones);
	}

	/**
	 * Reorder the selection made in Secciones table.
	 * 
	 *  filterSecciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterSecciones the filter secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(SeccionJ73 filterSecciones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.seccionesDao.reorderSelection(filterSecciones,
				jqGridRequestDto, startsWith);
	}

}
